@echo off
set flash_file=""
set comport=0
set zip_url=http://download.savannah.gnu.org/releases/avrdude/avrdude-6.4-mingw32.zip


@echo *** ROHM EVK Firmware updater for Arduino UNO R3***

rem check first that avrdude.exe file exists
if not exist avrdude.exe (
    @echo avrdude.exe not found. Please download and unzip the %zip_url% package first!
    exit /b 1
)    

rem find first hex file and set it to the flash_file variable
FOR /F "tokens=*" %%g IN ('dir /b *.hex') do (SET flash_file=%%g)

if %flash_file% == "" (
    @echo Firmware flash file '.hex' not found.
    exit /b 1
)
rem @echo flash_file: %flash_file%

@echo Connect Arduino UNO R3 board to PC with USB cable
@echo Press CTRL+C to stop, any other key to continue
pause >nul

@echo Resolving COM port ...
rem search the COM port of connected Arduino and set it to comport variable. VID and PID of all Arduino variants are used in searching
for /f "usebackq" %%B in (`wmic path Win32_SerialPort Where "PNPDeviceID LIKE 'USB\\VID_2341&PID_0043%%' OR PNPDeviceID LIKE 'USB\\VID_2341&PID_0001%%' OR PNPDeviceID LIKE 'USB\\VID_2341&PID_0243%%' OR PNPDeviceID LIKE 'USB\\VID_2A03&PID_0043%%'" Get DeviceID ^| FIND "COM"`) do set comport=%%B

if %comport% EQU 0 (
    @set /p comport="Enter Arduino COM port number: "
    goto :finalize_comport
) else (
    @echo COM port detected %comport%
    goto :comport_set
)
rem need to use separate goto block since all commands are cached and executed simultaneously upon exiting the code block
:finalize_comport
@set comport=COM%comport%

:comport_set
rem @echo comport: %comport%

@echo Flashing firmware %flash_file%. Please wait ...
avrdude.exe -q -q -p atmega328p -c arduino -P %comport% -b 115200 -D -U flash:w:%flash_file%:i -C avrdude.conf

if errorlevel 1 (
    @echo on
    @echo Firmware flashing failed!
    exit /b %errorlevel%
)

@echo Firmware flashing succeeded!